#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

static int get_global_id0(__global FilterParam* param)
{
	return get_global_id(0) - param->origROI[0]* param->width[0];
}

static int get_global_id1(__global FilterParam* param)
{
	return get_global_id(1) - param->origROI[1]* param->height[0];
}

vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}
	
vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

// Filter SunShine
__kernel void filter_SunShine(__read_only image2d_t image,   		// input image
							  __global uchar* clipTable,			// image buffer clip table
							  __write_only image2d_t retImage,   	// image result
							  __private int cx,
							  __private int cy,
							  __private int cr,
							  __private int thePixel,
							  __private int moveStep,
							  __private int alpha,					// blend factor, scrope[0-100]
							  __global FilterParam* param)	 					
{
	
	int width = get_image_width(image);
	int height = get_image_height(image);
	int W = get_global_size(0);
	int H = get_global_size(1);
	int w = get_global_id(0);
	int h = get_global_id(1);
	
	if(w >= width || h >= height)
			return;
	float2 resolution = (float2)(W,H);
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	w = fragCoord.x;
	h = fragCoord.y;
	
	if(w >= width || h >= height)
		return;
	uchar4 color = convert_uchar4(INPUTSRC(image, param, uv) * 255);
	uchar4 retColor;
	int dyy = (h - cy) * (h - cy);
	int dss = (w - cx) * (w - cx) + dyy;
	int crr = cr * cr;
	
	if(dss < crr)
	{
		int addPixel = (thePixel * (crr - dss)) >> moveStep;
		retColor.x = clipTable[color.x + addPixel];
		retColor.y = clipTable[color.y + addPixel];
		retColor.z = clipTable[color.z + addPixel];			
		retColor.w = color.w;
	}
	else
		retColor = color;
	
	float factor = (float)(alpha)/100.0f;
	float4 ret = (convert_float4(retColor) * factor + (1.0f - factor) * convert_float4(color)) / 255.0f;
	
	write_imagef(retImage, (int2)(get_global_id(0), get_global_id(1)), ret);
}